/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskCRSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskClusterIntegrity;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class NodeDelStage
extends Stage {
    private TaskCRSIntegrity taskCRSIntegrity;
    private TaskClusterIntegrity taskClusterIntegrity;
    private String m_osdba;
    private String m_oraInv;
    private String m_localNode;
    private String[] m_clusterNodes;
    private String[] m_newClusterNodes;
    private ParamPreReqNodeAddDel m_param;

    @Override
    public void init() throws StageInitException {
        super.init();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        this.m_param = new ParamPreReqNodeAddDel();
        try {
            this.m_clusterNodes = VerificationUtil.getStaticNodelist();
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("== Cluster nodelist: " + VerificationUtil.strArr2List(this.m_clusterNodes) + "\n== Parameter node(s): " + VerificationUtil.strArr2List(this.m_nodeList) + "\n"));
            }
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("==== NODELISTNOTFOUNDEXCEPTION: \n==== Could not get the local host name. \n" + e.getMessage()));
            Trace.stackTrace((Throwable)e);
            throw new StageInitException(new String[]{s_msgBundle.getMessage("4856", false), s_msgBundle.getMessage("4909", false), e.getMessage()});
        }
        if (this.m_verificationMode == 1) {
            // empty if block
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("== Node Removal list: " + VerificationUtil.strArr2List(this.m_nodeList)));
        }
        this.m_param.setNodes(this.m_nodeList);
        this.m_param.setValidClusterNodes(this.m_clusterNodes);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\nParameters: " + this.m_param.toString()));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    NodeDelStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    @Override
    protected boolean checkSetup() {
        ArrayList<String> clusterList = null;
        Object validNewNodeList = null;
        String[] validClusterNodeList = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (this.m_verificationMode == 1) {
            Trace.out((String)"Pre NodeDelete not supported, exiting.");
            return true;
        }
        boolean retval = this.validateEnvironment();
        if (!retval) {
            return false;
        }
        boolean saveMode = ReportUtil.getMode();
        ReportUtil.setMode(false);
        super.checkSetup(this.m_clusterNodes);
        ReportUtil.setMode(saveMode);
        validClusterNodeList = this.getValidNodeList();
        if (validClusterNodeList == null) {
            ReportUtil.printError(s_msgBundle.getMessage("7610", true) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("== Parameters: \n" + this.m_param.toString()));
            }
            this.setValidNodeList(new String[0]);
            return false;
        }
        this.m_param.setValidClusterNodes(this.getValidNodeList());
        clusterList = new ArrayList<String>(Arrays.asList(this.getValidNodeList()));
        for (String node : this.m_nodeList) {
            if (!clusterList.contains(node)) continue;
            clusterList.remove(node);
        }
        this.m_param.setValidNewClusterNodes(clusterList.toArray(new String[0]));
        this.m_newClusterNodes = this.m_param.getValidNewClusterNodes();
        this.getResultSet().clear();
        this.m_param.setValidNodes(this.m_nodeList);
        if (this.m_param.getValidNewClusterNodes().length == 0) {
            this.m_resultSet.addResult(this.m_nodeList, 3);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("== Parameters: \n" + this.m_param.toString()));
            }
            return false;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("== Parameters: \n" + this.m_param.toString()));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return true;
    }

    @Override
    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        boolean succ = false;
        boolean fail = false;
        ArrayList<String> clusterList = null;
        String[] validNodes = this.m_param.getValidNodes();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        clusterList = new ArrayList<String>(Arrays.asList(this.m_clusterNodes));
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\n\n  Node(s) specified on command line: " + VerificationUtil.strArr2List(this.m_nodeList) + "\n  Cluster nodes: " + VerificationUtil.strArr2List(this.m_clusterNodes)));
        }
        if (this.m_verificationMode == 1) {
            if (this.m_verificationMode == 1) {
                this.m_resultSet.addResult(this.m_nodeList, 1);
                this.m_resultSet.setStatus(1);
                this.m_resultSet.traceResultSet("Pre Node Delete not supported");
                return;
            }
            for (String delNode : validNodes) {
                if (clusterList.contains(delNode.toLowerCase())) continue;
                String errMsg = s_msgBundle.getMessage("4867", false, (Object[])new String[]{delNode});
                ReportUtil.printError(LSEP + errMsg + LSEP);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                this.m_resultSet.addResult(delNode, 3);
                fail = true;
            }
            succ = true;
            if (Trace.isLevelEnabled((int)1)) {
                this.m_resultSet.traceResultSet("Pre NodeDel");
            }
        } else {
            ArrayList<String> nodeDelList = new ArrayList<String>();
            for (String node : this.m_nodeList) {
                if (clusterList.contains(node.toLowerCase())) {
                    String errMsg = s_msgBundle.getMessage("4856", false) + LSEP + s_msgBundle.getMessage("4908", false, (Object[])new String[]{node});
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    this.m_resultSet.addResult(node, 3);
                    ReportUtil.printError(errMsg);
                    fail = true;
                    continue;
                }
                this.m_resultSet.addResult(node, 1);
                nodeDelList.add(node);
                succ = true;
            }
            if (succ && nodeDelList.size() != 0) {
                validNodes = nodeDelList.toArray(new String[0]);
                List<Task> nodeAddStageTaskList = null;
                nodeAddStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.POSTREQ_NODE_DEL, validNodes, this.m_param, this);
                this.addToCurrentTaskSet(nodeAddStageTaskList.toArray(new Task[0]));
            } else {
                Trace.out((String)("NO WORK!!\n Parameters: " + this.m_param.toString()));
            }
            if (Trace.isLevelEnabled((int)1)) {
                this.m_resultSet.traceResultSet("Post NodeDel");
            }
        }
        if (succ && !fail) {
            this.m_resultSet.setStatus(1);
        } else {
            this.m_resultSet.setStatus(3);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4440", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4493", false);
    }

    @Override
    public void generateReport() {
        ResultSet m_stageResultSet = this.getResultSet();
        ArrayList<String> nodeList = new ArrayList<String>(Arrays.asList(this.m_param.getNodes()));
        m_stageResultSet.traceResultSet("*** results BEFORE node purge...");
        Hashtable stageRT = m_stageResultSet.getResultTable();
        for (String node : this.m_clusterNodes) {
            if (nodeList.contains(node)) continue;
            stageRT.remove(node);
        }
        m_stageResultSet.setStatus();
        m_stageResultSet.traceResultSet("*** results AFTER node purge...");
    }
}

